//Items

StartupEvents.registry('item', (event) => {

    //Catalogs
    event.create('submerged:catalog_catalog').displayName('Catalog: Catalog').tag('shops:catalogs').maxStackSize(1).glow(true)
    
    event.create('submerged:catalog_hats').displayName('Catalog: Hats').tag('shops:catalogs').maxStackSize(1).glow(true)
    event.create('submerged:catalog_ducks').displayName('Catalog: Ducks').tag('shops:catalogs').maxStackSize(1).glow(true)
    event.create('submerged:catalog_simple_blocks').displayName('Catalog: Simple Blocks').tag('shops:catalogs').maxStackSize(1).glow(true)
    event.create('submerged:catalog_flares').displayName('Catalog: Flares').tag('shops:catalogs').maxStackSize(1).glow(true)
    event.create('submerged:catalog_relics').displayName('Catalog: Relics').tag('shops:catalogs').maxStackSize(1).glow(true)
    event.create('submerged:catalog_processor').displayName('Catalog: Processors').tag('shops:catalogs').maxStackSize(1).glow(true)
    event.create('submerged:catalog_capacitor').displayName('Catalog: Capacitors').tag('shops:catalogs').maxStackSize(1).glow(true)

    //Items
    event.create('submerged:unloaded_flare')
    event.create('submerged:stone_key')
    event.create('submerged:copper_key')
    event.create('submerged:iron_key')
    event.create('submerged:netherite_key')
    event.create('submerged:key_mold').tag(['c:molds/key', 'casting:molds'])
    event.create('submerged:mesh_mold').tag(['c:molds/mesh', 'casting:molds'])
    event.create('submerged:quartz_enriched_gold').tag(['c:ingots/quartz_enriched_gold', 'c:ingots'])
    event.create('submerged:infused_alloy').displayName('Infused Tainted Alloy')
    event.create('submerged:ancient_lens')
    event.create('submerged:blank_spawn_egg')
    event.create('submerged:raw_ancient_debris').tag(['c:raw_materials/ancient_debris', 'c:raw_materials'])
    event.create('submerged:ancient_debris_dust').tag(['c:dusts/ancient_debris', 'c:dusts'])
    event.create('submerged:porcelain_clay')
    event.create('submerged:wooden_key')
    event.create('submerged:wooden_gear').tag(['c:gears/wooden', 'c:gears'])
    event.create('submerged:corrupted_prismarine_crystal')
    event.create('submerged:starry_key')    
    event.create('submerged:ai_controller')    
    event.create('submerged:grains_of_time').displayName('Grains of Time Gone By')
    event.create('submerged:essence_of_the_sea')
    event.create('submerged:ice_ball')
    event.create('submerged:iridium_ore_piece')
    event.create('submerged:amethyst_dust')

    event.create('submerged:triarchium_gem').tag(['c:gems/triarchium', 'c:gems'])
    event.create('submerged:triarchium_ingot').tag(['c:ingots/triarchium', 'c:ingots'])

    event.create('submerged:prime_ingot').tag(['c:ingots/prime', 'c:ingots'])
    event.create('submerged:prime_alloy_ingot').tag(['c:ingots/prime_alloy', 'c:ingots'])

    event.create('submerged:logic_processor').tag('submerged:logic_processors').texture('ae2:item/logic_processor')
    event.create('submerged:calculation_processor').tag('submerged:calculation_processors').texture('ae2:item/calculation_processor')
    event.create('submerged:engineering_processor').tag('submerged:engineering_processors').texture('ae2:item/engineering_processor')
    
    event.create('submerged:solclipsium_ingot').tag(['c:ingots/solclipsium', 'c:ingots'])
    event.create('submerged:solclipsium_nugget').tag(['c:nuggets/solclipsium', 'c:nuggets'])
    event.create('submerged:cobblestone_ingot').tag(['c:ingots/cobblestone', 'c:ingots'])
    event.create('submerged:cobblestone_nugget').tag(['c:nuggets/cobblestone', 'c:nuggets'])

    event.create('submerged:certus_ingot').tag(['c:ingots/certus_infused', 'c:ingots'])
    event.create('submerged:prismarine_ingot').tag(['c:ingots/prismarine_infused', 'c:ingots'])
    
    //End Game Ingots
    event.create('submerged:create_ingot')
    event.create('submerged:pneumatic_ingot')
    event.create('submerged:infinity_fish_food')
    event.create('submerged:bright_dye')
    event.create('submerged:dark_dye')
    event.create('submerged:fishium_ingot')
    event.create('submerged:gravel_ingot')
    event.create('submerged:digital_ingot')
    event.create('submerged:mekanism_ingot')
    event.create('submerged:foregoing_ingot')
    
    //Infinity Drives
    event.create("submerged:infinity_sand_drive", 'infinity_drive').infinityStack("minecraft:sand")
    event.create("submerged:infinity_gravel_drive", 'infinity_drive').infinityStack("minecraft:gravel")
    event.create("submerged:infinity_dirt_drive", 'infinity_drive').infinityStack("minecraft:dirt")
    event.create("submerged:infinity_stone_drive", 'infinity_drive').infinityStack("minecraft:stone")

    event.create('submerged:ominous_drink').food(food => {food
            .nutrition(0)
            .saturation(0)
            .alwaysEdible(true)
            .effect("minecraft:bad_omen", 10*20, 0, 1.0)
            .eaten(ctx => {
                ctx.player.give(Item.of("minecraft:glass_bottle", 1))
            })
    }).displayName('Ominous Drink').useAnimation('drink')
    
    colors.forEach(color => {
        event.create(`submerged:${color}_terracotta_rocks`).tag('submerged:terracotta_rocks')
        event.create(`submerged:${color}_dirt_pile`).tag('submerged:dirt_pile')
    })

    //Nether Brick Sphere
    event.create('submerged:shrieking_sphere', 'roomopolis_key')
        .templateId('submerged:spheres/shrieking_sphere')
        .keyBlock('submerged:nether_brick_lock')
        .heightAdjustment(0)
        .frontAdjustment(-1)
        .doorLeft(1) 
        .doorRight(1)
        .doorUp(1)
        .doorDown(1)
        .consumeKey(true)
        .removeDoor(true)
        .blocksRequired(false)
        .overrideExistingBlocks(true)
        .tag('submerged:keys/sphere')

    //Nether Brick Sphere
    event.create('submerged:nether_brick_sphere', 'roomopolis_key')
        .templateId('submerged:spheres/nether_brick')
        .keyBlock('submerged:nether_brick_lock')
        .heightAdjustment(0)
        .frontAdjustment(-1)
        .doorLeft(1) 
        .doorRight(1)
        .doorUp(1)
        .doorDown(1)
        .consumeKey(true)
        .removeDoor(true)
        .blocksRequired(false)
        .overrideExistingBlocks(true)
        .tag('submerged:keys/sphere')

    //Nether Portal Sphere
    event.create('submerged:nether_portal_sphere', 'roomopolis_key')
        .templateId('submerged:spheres/nether_portal')
        .keyBlock('#submerged:terracotta_lock')
        .heightAdjustment(0)
        .frontAdjustment(-1)
        .doorLeft(1) 
        .doorRight(1)
        .doorUp(1)
        .doorDown(1)
        .consumeKey(true)
        .removeDoor(true)
        .blocksRequired(false)
        .overrideExistingBlocks(true)
        .tag('submerged:keys/sphere')

    //Colored Cube Keys
    colors.forEach(color => {
        event.create(`submerged:${color}_cube_key`, 'roomopolis_key')
            .templateId(`submerged:cubes/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(0)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag(['submerged:keys/cube_base', 'submerged:keys/standard'])
    })
    
    //Colored Sphere Keys 
    colors.forEach(color => {
        event.create(`submerged:${color}_sphere_key`, 'roomopolis_key')
            .templateId(`submerged:spheres/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(0)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag(['submerged:keys/sphere_base', 'submerged:keys/standard'])
    })

    //Colored Deep Cube Keys
    colors.forEach(color => {
        event.create(`submerged:${color}_deep_cube_key`, 'roomopolis_key')
            .templateId(`submerged:deep_cubes/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(-7)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag(['submerged:keys/deep', 'submerged:keys/deep_cube'])
    })

    //Colored Deep Sphere Keys 
    colors.forEach(color => {
        event.create(`submerged:${color}_deep_sphere_key`, 'roomopolis_key')
            .templateId(`submerged:deep/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(-7)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag(['submerged:keys/deep', 'submerged:keys/deep_sphere'])
    })

    //Colored Long Cube Keys
    colors.forEach(color => {
        event.create(`submerged:${color}_long_cube_key`, 'roomopolis_key')
            .templateId(`submerged:long_cubes/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(0)
            .frontAdjustment(6)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag(['submerged:keys/long', 'submerged:keys/long_cube'])
    })

    //Colored Long Sphere Keys 
    colors.forEach(color => {
        event.create(`submerged:${color}_long_sphere_key`, 'roomopolis_key')
            .templateId(`submerged:long/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(0)
            .frontAdjustment(6)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag(['submerged:keys/long', 'submerged:keys/long_sphere'])
    })

    //Colored Tunnel Keys 
    colors.forEach(color => {
        event.create(`submerged:${color}_tunnel_key`, 'roomopolis_key')
            .templateId(`submerged:tunnel/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(0)
            .frontAdjustment(4)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag('submerged:keys/tunnel')
    })

    //Colored Big Cube Keys
    colors.forEach(color => {
        event.create(`submerged:${color}_big_cube_key`, 'roomopolis_key')
            .templateId(`submerged:big_cubes/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(0)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .maxHeight(130)
            .tag(['submerged:keys/big', 'submerged:keys/big_cube'])
    })

    //Colored Big Sphere Keys 
    colors.forEach(color => {
        event.create(`submerged:${color}_big_sphere_key`, 'roomopolis_key')
            .templateId(`submerged:big/${color}`)
            .keyBlock(`#submerged:terracotta_lock`)
            .heightAdjustment(0)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .maxHeight(130)
            .tag(['submerged:keys/big', 'submerged:keys/big_sphere'])
    })

    event.create(`submerged:3x3_pressure_chamber`, 'roomopolis_key')
        .displayName('3x3 Pressure Chamber Key')
        .templateId(`submerged:pressure_chamber/3x3_pressure_chamber`)
        .keyBlock(`submerged:pressure_chamber_controller`)
        .heightAdjustment(1)
        .consumeKey(true)
        .removeDoor(false)
        .blocksRequired(true)
        .overrideExistingBlocks(false)
        .tag('submerged:keys/pressure_chamber')

    event.create(`submerged:4x4_pressure_chamber`, 'roomopolis_key')
        .displayName('4x4 Pressure Chamber Key')
        .templateId(`submerged:pressure_chamber/4x4_pressure_chamber`)
        .keyBlock(`submerged:pressure_chamber_controller`)
        .heightAdjustment(2)
        .consumeKey(true)
        .removeDoor(false)
        .blocksRequired(true)
        .overrideExistingBlocks(false)
        .tag('submerged:keys/pressure_chamber')

    event.create(`submerged:5x5_pressure_chamber`, 'roomopolis_key')
        .displayName('5x5 Pressure Chamber Key')
        .templateId(`submerged:pressure_chamber/5x5_pressure_chamber`)
        .keyBlock(`submerged:pressure_chamber_controller`)
        .heightAdjustment(2)
        .consumeKey(true)
        .removeDoor(false)
        .blocksRequired(true)
        .overrideExistingBlocks(false)
        .tag('submerged:keys/pressure_chamber')

    event.create(`submerged:overworld_altar`, 'roomopolis_key')
        .displayName('Overworld Altar Key')
        .templateId(`submerged:altar`)
        .keyBlock(`naturesaura:nature_altar`)
        .heightAdjustment(2)
        .frontAdjustment(-1)
        .consumeKey(true)
        .removeDoor(false)
        .blocksRequired(true)
        .overrideExistingBlocks(true)
        .sideOnlyPlacement(false)
        .topOnlyPlacement(true)
        .tag('submerged:keys/altar')

    event.create(`submerged:zombie_trial_sphere`, 'roomopolis_key')
        .templateId(`submerged:trial_spheres/zombie`)
        .keyBlock(`#submerged:terracotta_lock`)
        .heightAdjustment(0)
        .frontAdjustment(-1)
        .doorLeft(1)
        .doorRight(1)
        .doorUp(1)
        .doorDown(1)
        .consumeKey(true)
        .removeDoor(true)
        .blocksRequired(false)
        .overrideExistingBlocks(true)
        .tag('submerged:keys/trial_sphere')

    //Zombie is first
    const trialSphereOverworld = ["skeleton", "creeper", "pirate", "slime", "spider"]

    trialSphereOverworld.forEach(sphere => {
        event.create(`submerged:${sphere}_trial_sphere`, 'roomopolis_key')
            .templateId(`submerged:trial_spheres/${sphere}`)
            .keyBlock(`submerged:tuff_brick_lock`)
            .heightAdjustment(0)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag('submerged:keys/trial_sphere')
    })

    const trialSphereNether = ["wither_skeleton", "blaze", "fortress", "bastion"]

    trialSphereNether.forEach(sphere => {
        event.create(`submerged:${sphere}_trial_sphere`, 'roomopolis_key')
            .templateId(`submerged:trial_spheres/${sphere}`)
            .keyBlock(`submerged:nether_brick_lock`)
            .heightAdjustment(0)
            .frontAdjustment(-1)
            .doorLeft(1)
            .doorRight(1)
            .doorUp(1)
            .doorDown(1)
            .consumeKey(true)
            .removeDoor(true)
            .blocksRequired(false)
            .overrideExistingBlocks(true)
            .tag('submerged:keys/trial_sphere')
    })



    
})
